/*
 * trimite x si y de la mouse PS2
 * primeste date de la senzor touch s1 si s2
 * 
 * 
 * */
//https://microcontrollerslab.com/esp32-esp-now-two-way-communication-arduino-ide/
#include <esp_now.h>
#include <WiFi.h>

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

// REPLACE WITH THE MAC Address of your receiver 

uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0x51, 0xEC};
//adresa partener

//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC7, 0x78};
//adresa proprie   CC:50:E3:B6:C7:78

  int s1;  
  int s2;
  int s3;
  
   int x;
   int y;
   int z;

String success;

typedef struct struct_message {
    int s1;
    int s2;
    int s3; 
    int x;    //citeste x de la Mouse PS2
    int y;    //citeste y de la Mouse PS2
    int z;    //citeste scroll de la Mouse PS2
  } struct_message;

  #include "PS2Mouse.h"
  #define DATA_PIN 4   
  #define CLOCK_PIN 0
  PS2Mouse mouse(CLOCK_PIN, DATA_PIN);
  int distX =0; 
  int distY =0;
  int distZ =0; 

  struct_message trimite;
  struct_message primite;

  const int led3 = 27;
  const int led2 = 14;
  const int led1 = 12;

// Callback when data is sent
void data_sent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
  if (status ==0){
    success = "Delivery Success)";
  }
  else{
    success = "Delivery Fail";
  }
}

// Callback when data is received
  void data_receive(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&primite, incomingData, sizeof(primite));
  Serial.print("Bytes received: ");
  Serial.println(len);

if(primite.s1 < 80){
    digitalWrite(led1, HIGH); 
  }
  else{
    digitalWrite(led1, LOW);
  }
if(primite.s2 < 80){
    digitalWrite(led2, HIGH); 
  }
  else{
    digitalWrite(led2, LOW);
  }

  if(primite.s3 < 80){
    digitalWrite(led3, HIGH); 
  }
  else{
    digitalWrite(led3, LOW);
  }
}
 
void setup() {

  Serial.begin(115200);
  pinMode (led1, OUTPUT);
  pinMode (led2, OUTPUT);
  pinMode (led3, OUTPUT);
  mouse.initialize();
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Bilat PS2 mouse EspNow");
  display.display();
  delay(2000);

 
  WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_send_cb(data_sent);
  
  esp_now_peer_info_t peerInfo;
  memcpy(peerInfo.peer_addr, broadcastAddress, 6);
  peerInfo.channel = 0;  
  peerInfo.encrypt = false;       
  if (esp_now_add_peer(&peerInfo) != ESP_OK){
    Serial.println("Failed to add peer");
    return;
  }
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(data_receive);
}
 
void loop() {

  MouseData data = mouse.readData();
    distX+=data.position.x;
    distY+=data.position.y;
    distZ+=data.wheel;
    
  trimite.x = distX;
  trimite.y = distY;
  trimite.z = distZ;
  //trimite este nume generic pentru date trimise 
  //adica x,y si z
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &trimite, sizeof(trimite));
     
  if (result == ESP_OK) {
    Serial.println("Sent with success");
  }
  else {
    Serial.println("Error sending the data");
  }
  Display();
  delay(100);
  }

void Display(){
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);

  display.print("s1: ");
  display.print(primite.s1);
  display.setCursor(0, 20);
  display.print("s2: ");
  display.print(primite.s2);
  
  display.print(" s3: ");
  display.print(primite.s3);
  
  display.setCursor(60, 42);
  display.setTextSize(1);
  display.print(success);
  display.display();
      }
